
#include <xtl.h>

#include <d3dx8.h>

// ----------------------------------------------------------------------------------
#ifdef _XBOX

#define XFONT_TRUETYPE 

#include <xfont.h>

int lC = 86;
int rC = 109;
int lCWidth = 563;
int rCHeight = 394;
extern int sWidth;
extern int sHeight;
extern IDirect3DSurface8 *DirectBack;

class CTitleFontRenderer
{
public:
	CTitleFontRenderer() { m_pXFont = NULL;  };
    ~CTitleFontRenderer() { if( m_pXFont ) { m_pXFont->Release(); } };
    STDMETHODIMP_(ULONG)Release() { delete this; return 0; };
    STDMETHODIMP OpenFont( LPCWSTR pszFont ) {
        return XFONT_OpenTrueTypeFont( pszFont, 0x10000, &m_pXFont );
    };
    STDMETHODIMP DrawText( LPCWSTR pText, DWORD X, DWORD Y, DWORD MaxWidth ) {
        
		if(X == (sWidth/2)) {
            D3DRECT r = { 0, Y, 0 + MaxWidth, Y + 200 };
            m_pXFont->SetClippingRectangle( &r );
        }
		else {
            D3DRECT r = { X, Y, X + MaxWidth, Y + 200 };
            m_pXFont->SetClippingRectangle( &r );
        }

		if(MaxWidth == -1) {
			D3DRECT r = { lC, rC, lCWidth, rCHeight };
            m_pXFont->SetClippingRectangle( &r );
		}
		
        return m_pXFont->TextOut( DirectBack, pText, -1, X, Y );
    };

    STDMETHODIMP GetTextSize( LPCWSTR pText, DWORD *pWidth, DWORD *pHeight ) {
        *pHeight = m_pXFont->GetTextHeight();
        return m_pXFont->GetTextExtent( pText, -1, (UINT *)pWidth );
    };
    STDMETHODIMP SetColor( D3DCOLOR Color ) {
        m_pXFont->SetTextColor( Color );
        return S_OK;
    };
    STDMETHODIMP SetHeight( DWORD Height ) {
        return m_pXFont->SetTextHeight( Height );
    };
	XFONT *m_pXFont;

    
};


CTitleFontRenderer *ctfr = NULL;






//XFONT *Font=NULL;


int fUsed = 0;

int FontInit(int i )
{


	if(ctfr) {
		ctfr->Release(); 
		ctfr = NULL;
		ctfr  = new CTitleFontRenderer();
	}
	else {
		ctfr  = new CTitleFontRenderer();
	}
  
  
  ctfr->OpenFont( L"d:\\media\\ttfonts\\FRADM2.TTF" );
  return 0;
}

void FontExit()
{
}

int FontSetColour(unsigned int colour)
{
  ctfr->SetColor(colour); 
  //Font->SetTextColor(colour);
  return 0;
}
extern int HDMode;

int FontSmallText(WCHAR *text,int dx,int dy, int maxWidth)
{
//  if (Font==NULL || DirectBack==NULL) return 1;
  
  float y = 0;//dy * ((float)sHeight / 480);
  if(HDMode == 0) {
	 //x = dx;
	 y = dy;
  }
  if(HDMode == 1) {//1280x720;
	 //x = ((float)dx * 2.0f);
	 y = ((float)dy * 1.5f); 
  }
  if(HDMode == 2) { //1920x1080
	 //x = ((float)dx * 3.0f);
	 y = ((float)dy * 2.25f); 
  }

  ctfr->m_pXFont->SetTextAlignment(XFONT_TOP | XFONT_CENTER); 
  ctfr->DrawText(text, sWidth/2, y, sWidth); 
  //Font->TextOut(DirectBack,text,~0U,dx,dy);
  return 0;
}
void SetFontHeight(int v) {
	ctfr->m_pXFont->SetTextHeight(v); 
}
////616, 628, 640
int FontText(WCHAR *text,int dx,int dy, int maxWidth)
{
//  if (Font==NULL || DirectBack==NULL) return 1;
  
	
  float x = 0;//dx * ((float)sWidth / 640);
  float y = 0;//dy * ((float)sHeight / 480);

  if(HDMode == 0) {
	// maxWidth = 640;
	 x = dx;
	 y = dy;
  }
  if(HDMode == 1) {//1280x720;
	 //maxWidth = 1280;
	 x = ((float)dx * 2.0f);
	 y = ((float)dy * 1.5f); 
  }
  if(HDMode == 2) { //1920x1080
	// maxWidth = 1920;
	 x = ((float)dx * 3.0f);
	 y = ((float)dy * 2.25f); 
  }
  //float x = dx * ((float)sWidth / 640);
  //float y = dy * ((float)sHeight / 480);
  ctfr->m_pXFont->SetTextAlignment(XFONT_TOP | XFONT_LEFT);
  ctfr->DrawText(text, x, y, maxWidth); 
  //Font->TextOut(DirectBack,text,~0U,dx,dy);
  return 0;
}

int FontGuideText(WCHAR *text,int dx,int dy, int maxWidth)
{
//  if (Font==NULL || DirectBack==NULL) return 1;
  

  float x = 0;//dx * ((float)sWidth / 640);
  float y = 0;//dy * ((float)sHeight / 480);

  if(HDMode == 0) {
	 x = dx;
	 y = dy;
  }
  if(HDMode == 1) {//1280x720;
	 x = ((float)dx * 2.0f);
	 y = ((float)dy * 1.5f); 
  }
  if(HDMode == 2) { //1920x1080
	 x = ((float)dx * 3.0f);
	 y = ((float)dy * 2.25f); 
  }
  //float x = dx * ((float)sWidth / 640);
  //float y = dy * ((float)sHeight / 480);
  D3DRECT r = { 0, 0, sWidth, sHeight };
  ctfr->m_pXFont->SetClippingRectangle( &r );

  ctfr->m_pXFont->SetTextAlignment(XFONT_TOP | XFONT_LEFT);
  ctfr->DrawText(text, x, y, maxWidth); 
  //Font->TextOut(DirectBack,text,~0U,dx,dy);
  return 0;
}

int FontCenteredText(WCHAR *text,int dx,int dy, int maxWidth)
{
//  if (Font==NULL || DirectBack==NULL) return 1;
  
  float x = 0;//dx * ((float)sWidth / 640);
  float y = 0;//dy * ((float)sHeight / 480);
  if(HDMode == 0) {
	 x = dx;
	 y = dy;
  }
  if(HDMode == 1) {//1280x720;
	 x = ((float)dx * 2.0f);
	 y = ((float)dy * 1.5f); 
  }
  if(HDMode == 2) { //1920x1080
	 x = ((float)dx * 3.0f);
	 y = ((float)dy * 2.25f); 
  }
  D3DRECT r = { 0, 0, sWidth, sHeight };
  ctfr->m_pXFont->SetClippingRectangle( &r );
  //float y = dy * ((float)sHeight / 480);
  ctfr->m_pXFont->SetTextAlignment(XFONT_TOP | XFONT_CENTER); 
  //ctfr.DrawText(text, x, y, sWidth); 
  ctfr->m_pXFont->TextOut( DirectBack, text, -1, x, y );
  //Font->TextOut(DirectBack,text,~0U,dx,dy);
  return 0;
}

int FontRightText(WCHAR *text,int dx,int dy, int maxWidth)
{
//  if (Font==NULL || DirectBack==NULL) return 1;
  
  float x = 0;//dx * ((float)sWidth / 640);
  float y = 0;//dy * ((float)sHeight / 480);
  if(HDMode == 0) {
	 x = dx;
	 y = dy;
  }
  if(HDMode == 1) {//1280x720;
	 x = ((float)dx * 2.0f);
	 y = ((float)dy * 1.5f); 
  }
  if(HDMode == 2) { //1920x1080
	 x = ((float)dx * 3.0f);
	 y = ((float)dy * 2.25f); 
  }
  D3DRECT r = { 0, 0, sWidth, sHeight };
  ctfr->m_pXFont->SetClippingRectangle( &r );
  //float y = dy * ((float)sHeight / 480);
  ctfr->m_pXFont->SetTextAlignment(XFONT_TOP | XFONT_RIGHT); 
  //ctfr.DrawText(text, x, y, sWidth); 
  ctfr->m_pXFont->TextOut( DirectBack, text, -1, x, y );
  //Font->TextOut(DirectBack,text,~0U,dx,dy);
  return 0;
}

int FontLeftText(WCHAR *text,int dx,int dy, int maxWidth)
{
//  if (Font==NULL || DirectBack==NULL) return 1;
  
  float x = 0;//dx * ((float)sWidth / 640);
  float y = 0;//dy * ((float)sHeight / 480);
  if(HDMode == 0) {
	 x = dx;
	 y = dy;
  }
  if(HDMode == 1) {//1280x720;
	 x = ((float)dx * 2.0f);
	 y = ((float)dy * 1.5f); 
  }
  if(HDMode == 2) { //1920x1080
	 x = ((float)dx * 3.0f);
	 y = ((float)dy * 2.25f); 
  }
  D3DRECT r = { 0, 0, sWidth, sHeight };
  ctfr->m_pXFont->SetClippingRectangle( &r );
  //float y = dy * ((float)sHeight / 480);
  ctfr->m_pXFont->SetTextAlignment(XFONT_TOP | XFONT_LEFT); 
  //ctfr.DrawText(text, x, y, sWidth); 
  ctfr->m_pXFont->TextOut( DirectBack, text, -1, x, y );
  //Font->TextOut(DirectBack,text,~0U,dx,dy);
  return 0;
}

#endif


// ----------------------------------------------------------------------------------